import traceback
import logging

from cif2ini import cif2ini, ini2cif
from lib2dir import lib_extract, lib_archive


select_action_string = "Cultures decryptors and extractors by Mikulus (CulturesNation.pl)\n"\
    "[1] - extract *.lib (Cultures 1)\n" \
    "[2] - extract *.lib (Cultures 2)\n" \
    "[3] - archive *.lib (Cultures 1)\n" \
    "[4] - archive *.lib (Cultures 2)\n" \
    "[5] - convert *.ini to *.cif (Cultures 1)\n" \
    "[6] - convert *.ini to *.cif (Cultures 2)\n" \
    "[7] - convert *.cif to *.ini (Cultures 1 & 2) \n" \
    "[8] - convert *.tab or *.sal to *.txt (Cultures 1)\n" \
    "[9] - convert *.txt to *.tab or *.sal (Cultures 1)\n" \
    "Select action:"


while True:
    action = input(select_action_string)
    if action in [str(x) for x in range(10)]:
        input_path = input("Insert input path:")
        output_path = input("Insert output path:")

        try:

            if action == "1":
                lib_extract(input_path, output_path, cultures1=True)
            elif action == "2":
                lib_extract(input_path, output_path)
            elif action == "3":
                lib_archive(input_path, output_path, cultures1=True)
            elif action == "4":
                lib_archive(input_path, output_path)
            elif action == "5":
                ini2cif(input_path, output_path, cultures1=True)
            elif action == "6":
                ini2cif(input_path, output_path)
            elif action == "7":
                cif2ini(input_path, output_path)
            elif action == "8":
                cif2ini(input_path, output_path, tab_file=True)
            elif action == "9":
                ini2cif(input_path, output_path, tab_file=True, cultures1=True)

        except Exception as e:  # noqa
            logging.error(traceback.format_exc())

        else:
            print("Finished given task.")

    print()  # new line
